<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_service_area' );

function client_service_area() {
	$labels = array(
		'name'               => _x( 'Service Area', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Service Area', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Service Area', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Service Area', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Service Area', 'asdesign' ),
		'add_new_item'       => __( 'Add New Service Area', 'asdesign' ),
		'new_item'           => __( 'New Service Area', 'asdesign' ),
		'edit_item'          => __( 'Edit Service Area', 'asdesign' ),
		'view_item'          => __( 'View Service Area', 'asdesign' ),
		'all_items'          => __( 'All Service Area', 'asdesign' ),
		'search_items'       => __( 'Search Service Area', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Service Area:', 'asdesign' ),
		'not_found'          => __( 'No Service Area found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Service Area found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => false,
		'publicly_queryable' => false,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'service_area', $args );
}
?>