<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_physiotherapy' );

function client_physiotherapy() {
	$labels = array(
		'name'               => _x( 'Physiotherapy', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Physiotherapy', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Physiotherapy', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Physiotherapy', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Physiotherapy', 'asdesign' ),
		'add_new_item'       => __( 'Add New Physiotherapy', 'asdesign' ),
		'new_item'           => __( 'New Physiotherapy', 'asdesign' ),
		'edit_item'          => __( 'Edit Physiotherapy', 'asdesign' ),
		'view_item'          => __( 'View Physiotherapy', 'asdesign' ),
		'all_items'          => __( 'All Physiotherapy', 'asdesign' ),
		'search_items'       => __( 'Search Physiotherapy', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Physiotherapy:', 'asdesign' ),
		'not_found'          => __( 'No Physiotherapy found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Physiotherapy found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'our_physiotherapy', $args );
}
?>