<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_patient_center' );

function client_patient_center() {
	$labels = array(
		'name'               => _x( 'Patient Center', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Patient Center', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Patient Center', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Patient Center', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Patient Center', 'asdesign' ),
		'add_new_item'       => __( 'Add New Patient Center', 'asdesign' ),
		'new_item'           => __( 'New Patient Center', 'asdesign' ),
		'edit_item'          => __( 'Edit Patient Center', 'asdesign' ),
		'view_item'          => __( 'View Patient Center', 'asdesign' ),
		'all_items'          => __( 'All Patient Center', 'asdesign' ),
		'search_items'       => __( 'Search Patient Center', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Patient Center:', 'asdesign' ),
		'not_found'          => __( 'No Patient Center found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Patient Center found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'patient-center', $args );
}
?>