<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'client_condition' );

function client_condition() {
	$labels = array(
		'name'               => _x( 'Condition', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Condition', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Condition', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Condition', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Condition', 'asdesign' ),
		'add_new_item'       => __( 'Add New Condition', 'asdesign' ),
		'new_item'           => __( 'New Condition', 'asdesign' ),
		'edit_item'          => __( 'Edit Condition', 'asdesign' ),
		'view_item'          => __( 'View Condition', 'asdesign' ),
		'all_items'          => __( 'All Condition', 'asdesign' ),
		'search_items'       => __( 'Search Condition', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Condition:', 'asdesign' ),
		'not_found'          => __( 'No Condition found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Condition found in Trash.', 'asdesign' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => true,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);
	register_post_type( 'conditions', $args );
}
?>