<?php
   if ( ! defined( 'ABSPATH' ) ) {
     exit; // Exit if accessed directly
   }
?>

<?php get_header(); ?>
<?php $template_url = get_bloginfo ( 'template_url' ) . '/'; ?>
<?php 
   //to check if there is a post regarding the url access the page
   if (have_posts ()) :
     the_post(); 
   endif;
   
   $img = $template_url."images/background/inner-banner-bg-1-1.jpg";
?>
<section class="inner-banner bg-repeat-no bg-pos-center-center bg-coveer-sz" style="background-image: url(<?php echo $img;?>);">
            <div class="container">
                <h2 class="inner-banner__title">Blog Details</h2><!-- /.inner-banner__title -->
                <ul class="thm-breadcrumb">
                    <li class="thm-breadcrumb__item"><a class="thm-breadcrumb__link" href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
                    <li class="thm-breadcrumb__item current"><a class="thm-breadcrumb__link" href="#">Blog Details</a></li>
                </ul><!-- /.thm-breadcrumb -->
            </div><!-- /.container -->
        </section><!-- /.inner-banner -->
    
        <section class="blog-details sidebar-page">
            <div class="container">
                <div class="row high-gutters">
                    <div class="col-lg-8 col-md-12 col-sm-12">
                        <div class="blog-details__content">
                            <div class="service_details1__thumb mb-30">
                                        <img class="img_100" src="<?php echo get_the_post_thumbnail_url( get_the_ID(),'full');?>" alt="OilyTheme">
                                    </div>
                             <h2 class="inner-banner__title text-capitalize text-dark"><?php echo get_the_title();?></h2>
                            <?php echo get_the_content();?>
                        </div><!-- /.blog-details__content -->
                    </div><!-- /.col-lg-8 -->
                    <div class="col-lg-4 col-md-12 col-sm-12">
                        <div class="sidebar">
                            <div class="sidebar__single sidebar__post">
                                <h3 class="sidebar__title">Latest Article</h3><!-- /.sidebar__title -->
                                <div class="sidebar__post__wrap">
                                     <?php
                                         $args = array ( 
                                             'post_type'      => 'post',
                                             'post_status'    => 'publish', 
                                             'orderby' => 'publish_date',
                                             'order' => 'DESC',  
                                             'posts_per_page' => 10
                                         );
                                     $query = new WP_Query($args);
                                     $post_count = $query->post_count;
                                     if ( $query->have_posts() ){
                                       $i = 1;
                                     while ( $query->have_posts() ){
                                         $blog_img_url = get_the_post_thumbnail_url( get_the_ID(),'full');
                                         $query->the_post();
                                     ?>
                                     <div class="sidebar__post__single">
                                        <div class="sidebar__post__image">
                                            <img src="<?php echo get_the_post_thumbnail_url( get_the_ID(),'full');?>" alt="Awesome Image" />
                                        </div><!-- /.sidebar__post__image -->
                                        <div class="sidebar__post__content">
                                            <span class="sidebar__post__date"><?php echo get_the_date( 'D M j' );?></span>
                                            <h4 class="sidebar__post__title"><a href="<?php the_permalink();?>"><?php echo get_the_title();?></a></h4><!-- /.sidebar__post__title -->
                                        </div><!-- /.sidebar__post__content -->
                                    </div><!-- /.sidebar__post__single -->
                                    <?php
                                        $i++;
                                        }
                                      }wp_reset_postdata();
                                    ?>
                                </div><!-- /.sidebar__post__wrap -->
                            </div><!-- /.sidebar__single -->
                             
                        </div><!-- /.sidebar -->
                    </div><!-- /.col-lg-4 -->
                </div><!-- /.row -->
            </div><!-- /.container -->

<?php get_footer(); ?>