<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
add_action( 'init', 'header_slider' );
function header_slider() {
	$labels = array(
		'name'               => _x( 'Slider', 'post type general name', 'asdesign' ),
		'singular_name'      => _x( 'Slider', 'post type singular name', 'asdesign' ),
		'menu_name'          => _x( 'Slider', 'admin menu', 'asdesign' ),
		'name_admin_bar'     => _x( 'Slider', 'add new on admin bar', 'asdesign' ),
		'add_new'            => _x( 'Add New', 'Slider', 'asdesign' ),
		'add_new_item'       => __( 'Add New Slider', 'asdesign' ),
		'new_item'           => __( 'New Slider', 'asdesign' ),
		'edit_item'          => __( 'Edit Slider', 'asdesign' ),
		'view_item'          => __( 'View Slider', 'asdesign' ),
		'all_items'          => __( 'All Slider', 'asdesign' ),
		'search_items'       => __( 'Search Slider', 'asdesign' ),
		'parent_item_colon'  => __( 'Parent Slider:', 'asdesign' ),
		'not_found'          => __( 'No Slider found.', 'asdesign' ),
		'not_found_in_trash' => __( 'No Slider found in Trash.', 'asdesign' )
	);

	$args = array(
		'labels'             => $labels,
        'description'        => __( '', 'asdesign' ),
		'public'             => false,
		'publicly_queryable' => false,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => false ),
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail' )
	);
	register_post_type( 'our_slider', $args );
}
?>