<style>
@import url('https://fonts.googleapis.com/css?family=Nunito:400,600,700');
$nunito-font: 'Nunito', sans-serif;

// mixins
@mixin breakpoint($point) {
    @if $point==mobile {
        @media (max-width: 480px) and (min-width: 320px) {
            @content ;
        }
    }
}

// keyrames
@keyframes floating {
    from { transform: translateY(0px); }
    65%  { transform: translateY(15px); }
    to   { transform: translateY(-0px); }
}

html {
  height: 100%;
}

body{
  background-image: url('https://mars-404.templateku.co/img/star.svg'),linear-gradient(to bottom, #05007A, #4D007D);
  height: 100%;
  margin: 0;
  background-attachment: fixed;
  overflow: hidden;
}

.mars{
  left:0;
  right:0;
  bottom:0;
  position:absolute;
  height: 27vmin;
  background: url('https://mars-404.templateku.co/img/mars.svg') no-repeat bottom center;
  background-size: cover;
}

.logo-404{
  position: absolute;
  margin-left: auto;
  margin-right: auto;
  left: 0;
  right: 0;
  top: 16vmin;
  width: 30vmin;

  @include breakpoint(mobile){
    top: 45vmin;
  }
}

.meteor{
  position: absolute;
  right: 2vmin;
  top: 16vmin;
}

.title{
  color: white;
  font-family: $nunito-font;
  font-weight: 600;
  text-align: center;
  font-size: 5vmin;
  margin-top: 31vmin;

  @include breakpoint(mobile){
    margin-top: 65vmin;
  }
}

.subtitle{
  color: white;
  font-family: $nunito-font;
  font-weight: 400;
  text-align: center;
  font-size: 3.5vmin;
  margin-top: -1vmin;
  margin-bottom: 9vmin;
}

.btn-back{
  border: 1px solid white;
  color: white;
  height: 5vmin;
  padding: 12px;
  font-family: $nunito-font;
  text-decoration: none;
  border-radius: 5px;

  &:hover{
    background: white;
    color: #4D007D;
  }

  @include breakpoint(mobile){
    font-size: 3.5vmin;
  }
}

.astronaut{
  position: absolute;
  top: 18vmin;
  left: 10vmin;
  height: 30vmin;
  animation: floating 3s infinite ease-in-out;

  @include breakpoint(mobile){
    top: 2vmin;
  }
}

.spaceship{
  position: absolute;
  bottom: 15vmin;
  right: 24vmin;

  @include breakpoint(mobile){
    width: 45vmin;
    bottom: 18vmin;
  }
}
</style>
<div class="mars"></div>
<img src="https://assets.codepen.io/1538474/404.svg?__cf_chl_captcha_tk__=1c28df627808f7608390e402122f14cc03f953b3-1617795248-0-AftHtUxNrl5BvCo2o7R2KSvTDm_NR1BULD4tf42Z8SBWAkGuX-ekzdk3qOH9iY3U9qOUvbLaRcwn3KjJQ5D1aZHgx1eqJfwpZutku0HmG8ZDB1trNq7xYLb-l9p4jZ4IYmSsnuBYs6lnM7mfhULmDDkKjdYukcrAP76MVqEek0wll0tpo-js2E4Y5HgrHMU3Fi-q5e3brmGFoD_TrDO0sL_6PTnmeQ83YWlIu4KIJYOQQMpoqfKrCuzhz3S9lz64B2JVohfTjyYlLarILLLIjwBpwrUQXswx7i7belMNVvLFgZDLv7nZzhonbIc2b49jrFRgzfMcf-y5t8IDtiZgvmFtDQP2bXegFADqXTMT70eZm1dkuAcj2bf839IzvLZ8jhDK5qtLLLf2VoLTML_aVJsIQp_spYG-c7XvgmVR7J2GcElC4zVyFN38ZKAh3g7N68pUTVPwAKMC-xCH0L4lDCzjAS3UQbY8VjVvEl6usPwfyPs4UDTq-JT8EvirJbBNU2ClXcbR5gAO74EXNXiD03gMV8RmoR7-hHPAFeFm3FDjuKtNpa_H0EyKyVmUUW0JgEm5QJReCDRFlbx80BnqG5CCPu628E_ts-bJdxoKe83ECWbpm-3-NqFph9UDZXqpm89CrPRXNBKCRhVYvPXYU0XfhxNEMnqIimvesGjFKypO" class="logo-404" />
<img src="https://assets.codepen.io/1538474/meteor.svg" class="meteor" />
<p class="title">Oh no!!</p>
<p class="subtitle">
  You’re either misspelling the URL <br /> or requesting a page that's no longer here.
</p>
<div align="center">
  <a class="btn-back" href="<?php echo esc_url( home_url( '/' ) ); ?>">Back to previous page</a>
</div>
<img src="https://assets.codepen.io/1538474/astronaut.svg" class="astronaut" />
<img src="https://assets.codepen.io/1538474/spaceship.svg" class="spaceship" />